% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_polychoricMatrix3.R
\name{umx_polypairwise}
\alias{umx_polypairwise}
\title{FIML-based Pairwise polychoric, polyserial, and Pearson correlations}
\usage{
umx_polypairwise(
  data,
  useDeviations = TRUE,
  printFit = FALSE,
  use = "any",
  tryHard = c("no", "yes", "ordinal", "search")
)
}
\arguments{
\item{data}{Dataframe}

\item{useDeviations}{Whether to code the mode using deviation thresholds (default = TRUE)}

\item{printFit}{Whether to print information about the fit achieved (default = FALSE)}

\item{use}{parameter (default = "any")}

\item{tryHard}{'no' uses normal mxRun (default), "yes" uses mxTryHard, and others used named versions: "mxTryHardOrdinal", "mxTryHardWideSearch"}
}
\value{
- matrix of correlations
}
\description{
Compute polychoric/polyserial/Pearson correlations with FIML in OpenMx
}
\examples{
umx_set_optimizer("SLSQP")
tmp = mtcars
tmp$am = umxFactor(mtcars$am)
tmp$vs = umxFactor(mtcars$vs)
tmp = umx_scale(tmp)
x = umx_polypairwise(tmp[, c("hp", "mpg", "am", "vs")], tryHard = "yes")
x$R
cov2cor(x$R)
cor(mtcars[, c("hp", "mpg", "am", "vs")])
}
\references{
- \url{https://doi.org/10.3389/fpsyg.2016.00528}
}
\seealso{
Other Data Functions: 
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx}}
}
\concept{Data Functions}
