% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxCompare}
\alias{umxCompare}
\title{Print a comparison table of one or more \code{\link{mxModel}}s, formatted nicely.}
\usage{
umxCompare(base = NULL, comparison = NULL, all = TRUE, digits = 3,
  report = c("markdown", "inline", "html", "report"),
  compareWeightedAIC = FALSE, file = "tmp.html")
}
\arguments{
\item{base}{The base \code{\link{mxModel}} for comparison}

\item{comparison}{The model (or list of models) which will be compared for fit with the base model (can be empty)}

\item{all}{Whether to make all possible comparisons if there is more than one base model (defaults to T)}

\item{digits}{rounding for p-values etc.}

\item{report}{"markdown" (default), "inline" (a sentence suitable for inclusion in a paper), or "html".
create a web table and open your default browser.
(handy for getting tables into Word, and other text systems!)}

\item{compareWeightedAIC}{Show the Wagenmakers AIC weighted comparison (default = FALSE)}

\item{file}{file to write html too if report = "html" (defaults to "tmp.html")}
}
\description{
umxCompare compares two or more \code{\link{mxModel}}s. It has several nice features:

1. It supports direct control of rounding, and reports p-values rounded to APA style.

2. It reports the table in your preferred format (default is markdown, options include latex)

3. Table columns are arranged to make for easy comparison for readers.

4. report = 'inline', will provide an English sentence suitable for a paper.

5. report = "html" opens a web table in your browser to paste into a word processor.

\emph{Note}: If you leave comparison blank, it will just give fit info for the base model
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor", data = mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
m2 = umxModify(m1, update = "G_to_x2", name = "drop_path_2_x2")
umxCompare(m1, m2)
umxCompare(m1, m2, report = "report") # Add English-sentence descriptions
\dontrun{
umxCompare(m1, m2, report = "html") # Open table in browser
}
m3 = umxModify(m2, update = "G_to_x3", name = "drop_path_2_x2_and_3")
umxCompare(m1, c(m2, m3))
umxCompare(m1, c(m2, m3), compareWeightedAIC = TRUE)
umxCompare(c(m1, m2), c(m2, m3), all = TRUE)
}
\references{
- \url{https://www.github.com/tbates/umx/}
}
\seealso{
- \code{\link{mxCompare}}, \code{\link{umxSummary}}, \code{\link{umxRAM}},

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxConfint}}, \code{\link{umxExpCov}},
  \code{\link{umxExpMeans}}, \code{\link{umxFitIndices}},
  \code{\link{umxPlotACEv}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
\concept{Reporting functions}
