% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_set_optimization_options}
\alias{umx_set_optimization_options}
\title{umx_set_optimization_options}
\usage{
umx_set_optimization_options(opt = c("mvnRelEps", "mvnMaxPointsA"),
  value = NULL, model = NULL, silent = FALSE)
}
\arguments{
\item{opt}{default returns current values of the options listed. Currently
"mvnRelEps" and "mvnMaxPointsA".}

\item{value}{If not NULL, the value to set the opt to (can be a list of length(opt))}

\item{model}{A model for which to set the optimizer. Default (NULL) sets the optimizer globally.}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
-
}
\description{
Set options that affect optimization in OpenMx. For mvnRelEps,  values between .0001 to .01 are conventional.
Smaller values slow optimization.
}
\examples{
umx_set_optimization_options() # print the existing state(s)
umx_set_optimization_options("mvnRelEps") # show this one
\dontrun{
umx_set_optimization_options("mvnRelEps", .01) # update globally
}
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Get and set: \code{\link{umx_default_option}},
  \code{\link{umx_get_checkpoint}},
  \code{\link{umx_get_options}},
  \code{\link{umx_set_auto_plot}},
  \code{\link{umx_set_auto_run}},
  \code{\link{umx_set_checkpoint}},
  \code{\link{umx_set_condensed_slots}},
  \code{\link{umx_set_cores}},
  \code{\link{umx_set_optimizer}},
  \code{\link{umx_set_plot_file_suffix}},
  \code{\link{umx_set_plot_format}},
  \code{\link{umx_set_table_format}}, \code{\link{umx}}
}
