% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umx_get_CI_as_APA_string}
\alias{umx_get_CI_as_APA_string}
\title{umx_get_CI_as_APA_string}
\usage{
umx_get_CI_as_APA_string(model, cellLabel, prefix = "top.", suffix = "_std",
  digits = 2, verbose = FALSE)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to get CIs from}

\item{cellLabel}{the label of the cell to interogate for a CI, e.g. "ai_r1c1"}

\item{prefix}{This submodel to look in (i.e. "top.")}

\item{suffix}{The suffix for algebras ("_std")}

\item{digits}{= 2}

\item{verbose}{= FALSE}
}
\value{
- the CI string, e.g. ".73 [-.2, .98]"
}
\description{
Look up CIs for free parameters in a model, and return as APA-formatted text string
}
\examples{
\dontrun{
umx_get_CI_as_APA_string(fit_IP, cellLabel = "ai_r1c1", prefix = "top.", suffix = "_std")
}
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Miscellaneous Functions: \code{\link{umxEval}};
  \code{\link{umxJiggle}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_add_variances}}; \code{\link{umx_apply}};
  \code{\link{umx_check_OS}};
  \code{\link{umx_check_model}};
  \code{\link{umx_check_multi_core}};
  \code{\link{umx_checkpoint}},
  \code{\link{umx_set_checkpoint}};
  \code{\link{umx_check}};
  \code{\link{umx_default_option}};
  \code{\link{umx_get_bracket_addresses}};
  \code{\link{umx_get_checkpoint}};
  \code{\link{umx_get_cores}};
  \code{\link{umx_get_optimizer}};
  \code{\link{umx_has_CIs}};
  \code{\link{umx_has_been_run}};
  \code{\link{umx_has_means}};
  \code{\link{umx_has_square_brackets}};
  \code{\link{umx_is_MxMatrix}};
  \code{\link{umx_is_MxModel}}; \code{\link{umx_is_RAM}};
  \code{\link{umx_is_cov}};
  \code{\link{umx_is_endogenous}};
  \code{\link{umx_is_exogenous}};
  \code{\link{umx_is_ordered}};
  \code{\link{umx_object_as_str}};
  \code{\link{umx_reorder}}; \code{\link{umx_set_cores}};
  \code{\link{umx_set_optimizer}};
  \code{\link{umx_standardize_IP}};
  \code{\link{umx_string_to_algebra}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

