% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{plot.MxModel}
\alias{plot.MxModel}
\alias{umxPlot}
\title{Create a figure from an MxModel}
\usage{
\method{plot}{MxModel}(x = NA, std = TRUE, digits = 2,
  dotFilename = "name", pathLabels = c("none", "labels", "both"),
  showFixed = FALSE, showMeans = TRUE, showError = TRUE, ...)
}
\arguments{
\item{x}{an \code{\link{mxModel}} from which to make a path diagram}

\item{std}{Whether to standardize the model.}

\item{digits}{The number of decimal places to add to the path coefficients}

\item{dotFilename}{A file to write the path model to. if you leave it at the default "name", then the model's internal name will be used}

\item{pathLabels}{Whether to show labels on the paths. both will show both the parameter and the label. ("both", "none" or "labels")}

\item{showFixed}{Whether to show fixed paths (defaults to FALSE)}

\item{showMeans}{Whether to show means}

\item{showError}{Whether to show errors}

\item{...}{Optional parameters}
}
\description{
Create graphical path diagrams from your OpenMx models!
}
\examples{
\dontrun{
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
plot(m1)
}
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{umxLabel}}, \code{\link{umxRun}}, \code{\link{umxValues}}

Other Reporting functions: \code{\link{RMSEA.MxModel}};
  \code{\link{RMSEA.summary.mxmodel}}; \code{\link{RMSEA}};
  \code{\link{coef.MxModel}};
  \code{\link{confint.MxModel}};
  \code{\link{extractAIC.MxModel}};
  \code{\link{logLik.MxModel}}; \code{\link{plot}},
  \code{\link{plot.MxModel.ACE}}, \code{\link{umxPlotACE}};
  \code{\link{residuals.MxModel}};
  \code{\link{umxCI_boot}}; \code{\link{umxCI}};
  \code{\link{umxCompare}}; \code{\link{umxExpCov}};
  \code{\link{umxExpMeans}}; \code{\link{umxFitIndices}};
  \code{\link{umxStandardizeModel}};
  \code{\link{umxSummary.MxModel}};
  \code{\link{umx_drop_ok}}
}

