% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setCaptionNumberingKnitrHook.R,
%   R/setFigCapNumbering.R, R/setTabCapNumbering.R
\name{setCaptionNumberingKnitrHook}
\alias{setCaptionNumberingKnitrHook}
\alias{setFigCapNumbering}
\alias{setTabCapNumbering}
\title{Set a knitr hook for caption numbering}
\usage{
setCaptionNumberingKnitrHook(
  captionName = "fig.cap",
  prefix = "Figure \%s: ",
  suffix = "",
  optionName = paste0("setCaptionNumbering_", captionName),
  resetCounterTo = 1
)

setFigCapNumbering(
  captionName = "fig.cap",
  prefix = "Figure \%s: ",
  suffix = "",
  optionName = paste0("setCaptionNumbering_", captionName),
  resetCounterTo = 1
)

setTabCapNumbering(
  captionName = "tab.cap",
  prefix = "Table \%s: ",
  suffix = "",
  optionName = paste0("setCaptionNumbering_", captionName),
  resetCounterTo = 1
)
}
\arguments{
\item{captionName}{The name of the caption; for example, \code{fig.cap}
or \code{tab.cap}.}

\item{prefix, suffix}{The prefix and suffix; any occurrences of
\verb{\\\%s} will be replaced by the number.}

\item{optionName}{THe name to use for the option that keeps track
of the numbering.}

\item{resetCounterTo}{Whether to reset the counter (as stored in the
options), and if so, to what value (set to \code{FALSE} to prevent resetting).}
}
\value{
\code{NULL}, invisibly.
}
\description{
Set a knitr hook to automatically number captions for, e.g., figures
and tables. \code{setCaptionNumberingKnitrHook()} is the general purpose
function; you normally use \code{setFigCapNumbering()} or \code{setTabCapNumbering()}.
}
\examples{
### To start automatically numbering figure captions
setFigCapNumbering();

### To start automatically numbering table captions
setTabCapNumbering();
}
