% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{strsplit.data.frame}
\alias{strsplit.data.frame}
\title{Obtain a tokenised data frame by splitting text alongside a regular expression}
\usage{
strsplit.data.frame(
  data,
  term,
  group,
  split = "[[:space:][:punct:][:digit:]]+",
  ...
)
}
\arguments{
\item{data}{a data.frame or data.table}

\item{term}{a character with a column name from \code{data} which you want to split into tokens}

\item{group}{a string with a column name or a character vector of column names from \code{data} indicating identifiers of groups. 
The text in \code{term} will be split into tokens by group.}

\item{split}{a regular expression indicating how to split the \code{term} column. 
Defaults to splitting by spaces, punctuation symbols or digits. This will be passed on to \code{\link{strsplit}}.}

\item{...}{further arguments passed on to \code{\link{strsplit}}}
}
\value{
A tokenised data frame containing one row per token.\cr
This data.frame has the columns from \code{group} and \code{term} where the text in column \code{term}
will be split by the provided regular expression into tokens.
}
\description{
Obtain a tokenised data frame by splitting text alongside a regular expression. 
This is the inverse operation of \code{\link{paste.data.frame}}.
}
\examples{
data(brussels_reviews, package = "udpipe")
x <- strsplit.data.frame(brussels_reviews, term = "feedback", group = "id")
head(x)
x <- strsplit.data.frame(brussels_reviews, 
                         term = c("feedback"), 
                         group = c("listing_id", "language"))
head(x)  
x <- strsplit.data.frame(brussels_reviews, term = "feedback", group = "id", 
                         split = " ", fixed = TRUE)
head(x)                          
}
\seealso{
\code{\link{paste.data.frame}}, \code{\link{strsplit}}
}
