% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distamp.R
\name{stan_distsamp}
\alias{stan_distsamp}
\title{Fit the Royle et al. (2004) Distance Sampling Model}
\usage{
stan_distsamp(
  formula,
  data,
  keyfun = c("halfnorm", "exp", "hazard"),
  output = c("density", "abund"),
  unitsOut = c("ha", "kmsq"),
  ...
)
}
\arguments{
\item{formula}{Double right-hand side formula describing covariates of
detection and occupancy in that order}

\item{data}{A \code{\link{unmarkedFrameDS}} object}

\item{keyfun}{One of the following detection functions:
\code{"halfnorm"} for half-normal, \code{"exp"} for negative exponential,
or \code{"hazard"} for hazard-rate (see warning below)}

\item{output}{Model either density \code{"density"} or abundance \code{"abund"}}

\item{unitsOut}{Units of density. Either \code{"ha"} or \code{"kmsq"} for
hectares and square kilometers, respectively}

\item{...}{Arguments passed to the \code{\link{stan}} call, such as
number of chains \code{chains} or iterations \code{iter}}
}
\value{
\code{ubmsFitDistsamp} object describing the model fit.
}
\description{
This function fits the hierarchical distance sampling model of Royle
et al. (2004) to line or point transect data recorded in discerete
distance intervals.
}
\note{
Values of `dist.breaks` in the `unmarkedFrameDS` should be as small
 as possible (<10) to facilitate convergence. Consider converting `unitsIn` from
 meters to kilometers, for example. See example below.
}
\section{Warning}{
 Use of the hazard-rate key function (\code{"hazard"})
 typically requires a large sample size in order to get good parameter
 estimates. If you have a relatively small number of points/transects (<100),
 you should be cautious with the resulting models. Check your results against
 estimates from \code{unmarked}, which doesn't require as much data to get
 good estimates of the hazard-rate shape and scale parameters.
}

\examples{
\donttest{
data(issj)
#Note use of km instead of m for distance breaks
jayUMF <- unmarkedFrameDS(y=as.matrix(issj[,1:3]),
                          siteCovs=issj[,c("elevation","forest")],
                          dist.breaks=c(0,0.1,0.2,0.3),
                          unitsIn="km", survey="point")

fm_jay <- stan_distsamp(~1~scale(elevation), jayUMF, chains=3, iter=300)
}

}
\references{
Royle, J. A., Dawson, D. K., & Bates, S. (2004). Modeling
 abundance effects in distance sampling. Ecology 85: 1591-1597.
}
\seealso{
\code{\link{distsamp}}, \code{\link{unmarkedFrameDS}}
}
