% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipper.R
\name{toClip}
\alias{toClip}
\title{Visual clipper}
\usage{
toClip(rad = 1, segments = 5, centre = c(0, 0))
}
\arguments{
\item{rad}{The circle radius.}

\item{segments}{How many segments should the resulting polygon have? (because it is not a circle, 20 is ok).}

\item{centre}{The coordinates of the polygon centre (x,y).}
}
\value{
An object of class \code{\link[=clipmask-class]{clipmask}}.
}
\description{
Visual aid to find the right center and radius for the \code{\link{clipper}} function. It does not clip, but return an usable (plotable) object.

Since the samples are placed under the uFTIR Microscope by hand, the cropping area to pass to \code{\link{clipper}} is not always the same and (usually) it has to be adjusted. To have a visual aid, you can use this function. It returns an S4 object of class \code{\link[=clipmask-class]{clipmask}} which can be over-plotted on top of a \code{\link[=SAM-class]{SAM}} or \code{\link[=Smooth-class]{Smooth}} object by calling \code{\link[graphics]{polygon}} and using the xycoords slot of the returned object. Using that process you can test manually different center points and radius for the clipping circle.
}
\examples{
toClip(1, 5, c(0,0))

x <- tile_read(base::system.file("extdata/tile.bsp", package = "uFTIR"))
x <- tile_base_corr(x)
x <- wavealign(x, primpke)
x <- tile_sam(x)
x <- smooth_sam(x, as.integer(length(primpke@clusternames)), window = 3, 1)

clip <- toClip(8,20,c(10,10))
polygon(clip@xycoords)

x <- clipper(x, clip@centre, clip@rad, 1)

}
\seealso{
\code{\link{clipper}}
}
