% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mechanisms.R
\name{est_g_exp}
\alias{est_g_exp}
\title{Estimate the Exposure Mechanism via Generalized Propensity Score}
\usage{
est_g_exp(
  A,
  W,
  delta = 0,
  samp_weights = rep(1, length(A)),
  fit_type = c("hal", "sl"),
  sl_learners_density = NULL,
  haldensify_args = list(grid_type = "equal_range", lambda_seq = exp(seq(-1, -13,
    length = 300)))
)
}
\arguments{
\item{A}{A \code{numeric} vector of observed exposure values.}

\item{W}{A \code{numeric} matrix of observed baseline covariate values.}

\item{delta}{A \code{numeric} value identifying a shift in the observed
value of the exposure under which observations are to be evaluated.}

\item{samp_weights}{A \code{numeric} vector of observation-level sampling
weights, as produced by the internal procedure to estimate the two-phase
sampling mechanism \code{\link{est_samp}}.}

\item{fit_type}{A \code{character} specifying whether to use Super Learner
(from \pkg{sl3}) or the Highly Adaptive Lasso (from \pkg{hal9001}) to
estimate the conditional exposure density.}

\item{sl_learners_density}{Object containing a set of instantiated learners
from \pkg{sl3}, to be used in fitting an ensemble model.}

\item{haldensify_args}{A \code{list} of argument to be directly passed to
\code{\link[haldensify]{haldensify}} when \code{fit_type} is set to
\code{"hal"}. Note that this invokes the Highly Adaptive Lasso instead of
Super Learner and is thus only feasible for relatively small data sets.}
}
\value{
A \code{data.table} with four columns, containing estimates of the
 generalized propensity score at a downshift (g(A - delta | W)), no shift
 (g(A | W)), an upshift (g(A + delta) | W), and an upshift of magnitude two
 (g(A + 2 delta) | W).
}
\description{
Estimate the Exposure Mechanism via Generalized Propensity Score
}
\details{
Compute the propensity score (exposure mechanism) for the observed
 data, including the shift. This gives the propensity score for the observed
 data (at the observed A) the counterfactual shifted exposure levels (at
 {A - delta}, {A + delta}, and {A + 2 * delta}).
}
