% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweedie_profile.R
\name{tweedie_profile}
\alias{tweedie_profile}
\alias{tweedie.profile}
\title{Profile Likelihood Estimate of Tweedie Variance Index Parameter}
\usage{
tweedie_profile(formula, p.vec = NULL, xi.vec = NULL, link.power = 0, 
  data, weights = 1, offset = 0, fit.glm = FALSE, do.smooth = TRUE, 
  do.plot = FALSE, do.ci = do.smooth, eps = 1/6, 
  control = list( epsilon = 1e-09, maxit = stats::glm.control()$maxit, 
  trace = glm.control()$trace ),
  do.points = do.plot, method = "inversion", conf.level = 0.95, 
  phi.method = ifelse(method == "saddlepoint", "saddlepoint", "mle"), 
  verbose = FALSE, add0 = FALSE)

tweedie.profile(
  formula,
  p.vec = NULL,
  xi.vec = NULL,
  link.power = 0,
  data,
  weights = 1,
  offset = 0,
  fit.glm = FALSE,
  do.smooth = TRUE,
  do.plot = FALSE,
  do.ci = do.smooth,
  eps = 1/6,
  control = list(epsilon = 1e-09, maxit = stats::glm.control()$maxit, trace =
    glm.control()$trace),
  do.points = do.plot,
  method = "inversion",
  conf.level = 0.95,
  phi.method = ifelse(method == "saddlepoint", "saddlepoint", "mle"),
  verbose = FALSE,
  add0 = FALSE
)
}
\arguments{
\item{formula}{a formula expression as for other regression models and
generalized linear models, of the form \code{response ~ predictors}.}

\item{p.vec}{a vector of \eqn{p}{power} values for consideration. 
The values must all be larger than one. 
If the response has zeros, values must be \eqn{1 < p < 2}.
If \code{NULL} (default), \code{p.vec} is set automatically.}

\item{xi.vec}{a synonym for \code{p.vec}, as some authors use the \eqn{\xi}{xi} notation.}

\item{link.power}{the power link function to use in the \code{tweedie} \acronym{glm} family. 
These link functions \eqn{g(\cdot)}{g()} are of the form \eqn{g(\eta)=\eta^{link.power}}{g(\eta) = \eta^{\text{link.power}}}, where \code{link.power = 0} (default) refers to the logarithm link function.}

\item{data}{an optional data frame, list or environment containing the variables.}

\item{weights}{an optional vector of weights to be used in the fitting process.}

\item{offset}{an \emph{a priori} known component included in the linear predictor.
See \code{\link{model.offset}}.}

\item{fit.glm}{logical; if \code{TRUE}, the Tweedie \acronym{glm} is fitted using the
value of \eqn{p} found by the profiling function. The default is \code{FALSE}.}

\item{do.smooth}{logical; if \code{TRUE} (default), a spline is fitted to the
data to smooth the profile likelihood plot. \bold{Note} that \code{p.vec}
must contain \emph{at least five points} for smoothing.}

\item{do.plot}{logical; if \code{TRUE}, a plot of the profile likelihood is produced.
The default is \code{FALSE}.}

\item{do.ci}{logical; if \code{TRUE}, the nominal \code{100*conf.level} is computed.
Defaults to the value of \code{do.smooth}. 
Confidence intervals are only computed if \code{do.smooth = TRUE}.}

\item{eps}{the offset in computing the variance function. Default is \code{1/6} (as recommended by Nelder and Pregibon, 1987).
\code{eps} is ignored unless \code{method = "saddlepoint"}.}

\item{control}{a list of parameters for controlling the fitting process;}

\item{do.points}{logical; if \code{TRUE}, the points used to compute the likelihood as given by \code{p.vec} (or equivalently, \code{xi.vec}) are explicitly shown by points. 
The defaults is the value of \code{do.plot}.}

\item{method}{the method of evaluation; one of \code{saddlepoint}, \code{interpolation}, \code{series} or \code{inversion} (the default).}

\item{conf.level}{the level of confidence for the confidence intervals; the default is \code{0.95} (for \eqn{95\%}{95\%} confidence intervals).}

\item{phi.method}{the method used to estimate \eqn{\phi}{phi}; one of \code{saddlepoint}, \code{mle} (the default).}

\item{verbose}{logical; if \code{TRUE}, some details of the calculations are shown. The default is \code{FALSE}.}

\item{add0}{logical; if \code{TRUE}, adds \eqn{P(Y = 0)}{P(Y = 0)} to the plot. The default is \code{FALSE}.}
}
\description{
This function profiles the (log-)likelihood over a vector of
  Tweedie power-index parameter (denoted \eqn{p}{power} or \eqn{\xi}{xi}) to find the maximum
  likelihood estimate (MLE) of the index parameter \eqn{p} (or equivalently \eqn{\xi}{xi}).
}
\details{
For each value in \code{p.vec}, the function computes an estimate of \eqn{\phi}{phi}
and then computes the value of the log-likelihood for these parameters.
The plot of the log-likelihood against \code{p.vec} allows the maximum
likelihood value of \eqn{p}{p} to be found. 
Once \eqn{p}{p} is found, the distribution within the class of Tweedie distributions is identified.
}
\note{
The estimates of \eqn{p}{p} and \eqn{\phi}{phi} are printed invisibly. 
If the response variable has any exact zeros, the values in \code{p.vec} must all be
between one and two.

The function can be temperamental (for theoretical reasons involved in numerically computing
the density; see Dunn and Smyth (2005)) and may be very slow or fail. 
One solution is to change the method. 
The default is \code{method = "inversion"}; then try \code{"series"}, \code{"interpolation"}, 
and \code{"saddlepoint"} in that order.
Note that \code{method = "saddlepoint"} is an approximate method only.

It is recommended that for the first use with a data set, use \code{p.vec}
with only a small number of values and set \code{do.smooth = FALSE},
\code{do.ci = FALSE}. If this is successful, a larger vector \code{p.vec}
and smoothing can be used.
}
\examples{
data(rock)
out <- tweedie_profile(perm~1, data=rock, do.plot=FALSE, 
                       xi.vec=seq(1.5, 2.75, length=11))

# The estimate for the variance power index (p, or xi) is:
out$p.max

}
\references{
Dunn, P. K. and Smyth, G. K. (2018).
Generalized linear models with examples in R.
Springer.
\doi{10.1007/978-1-4419-0118-7}
}
\keyword{models}
