% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrGH.R
\name{distr-gh}
\alias{distr-gh}
\alias{dgh}
\alias{pgh}
\alias{qgh}
\alias{rgh}
\alias{infgh}
\alias{supgh}
\title{The Tukey's g-and-h distribution}
\usage{
dgh(x, a = 0, b = 1, g = 0, h = 0.2, log = FALSE, ...)

pgh(q, a = 0, b = 1, g = 0, h = 0.2, lower.tail = TRUE, log.p = FALSE, ...)

qgh(p, a = 0, b = 1, g = 0, h = 0.2, lower.tail = TRUE, log.p = FALSE)

rgh(n, a = 0, b = 1, g = 0, h = 0.2)

infgh(a = 0, b = 1, g = 0, h = 0.2)

supgh(a = 0, b = 1, g = 0, h = 0.2)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{a}{location parameter(s).}

\item{b}{scale parameter(s).}

\item{g}{skewness parameter(s).}

\item{h}{heavy-taildness parameter(s). Only non-negative values will be
accepted (see \emph{Details}).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{...}{arguments passed to \code{\link[rootSolve:uniroot.all]{rootSolve::uniroot.all()}}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length
    is taken to be the number required.}
}
\value{
\code{dgh} gives the density, \code{pgh} gives the distribution function, \code{qgh} gives
the quantile function, and \code{rgh} generates random numbers.

The length of the result is determined by \code{n} for \code{rgh}, and is the maximum
of the lengths of the numerical arguments for the other functions.

The numerical arguments other than \code{n} are recycled to the length of the
result. Only the first elements of the logical arguments are used.
}
\description{
Density (\code{dgh}), distribution function (\code{pgh}), quantile function (\code{qgh}),
random generation (\code{rgh}), and bounds of the support (\code{infgh} and \code{supgh})
of the Tukey's g-and-h distribution \insertCite{tukey1977}{tukeyGH}. All
functions with the exception of \code{rgh} are vectorized with respect to all
arguments on the Tukey's distribution (\code{x}, \code{q}, \code{p}, \code{a}, \code{b}, \code{g}, \code{h}).
}
\details{
Given a Gaussian random variable \eqn{Z\sim\mathcal{N}(0, 1)}, the following
transformation:
\deqn{
X=a+b\,\frac{e^{gZ}-1}{g}\,e^{\frac{hZ^2}{2}}
}
defines the Tukey's g-and-h distribution. Hence \eqn{X\sim gh(a, b, g, h)}
denotes a random variable distributed according to the Tukey's g-and-h
distribution function, where \eqn{a\in\mathbf{R}} is the location parameter,
\eqn{b\in\mathbf{R}^+} is the scale parameter, \eqn{g\in\mathbf{R}} is the
skewness parameter, and \eqn{h\in\mathbf{R}^+} is the shape parameter.

In principle, the shape parameter \eqn{h} may also take negative values,
however, in such a case, the above transformation is not monotone. All
functions on this page require that \eqn{h\geq0}.

Note that, when \eqn{g=0}, the limit for \eqn{g\to 0} of the previous
transformation is considered:
\deqn{
X=\lim_{g\to0}\left(a+b\,\frac{e^{gZ}-1}{g}\,e^{\frac{hZ^2}{2}}\right)=
a+b\,Z\,e^{\frac{hZ^2}{2}}
}
so that \eqn{X\sim gh(a, b, 0, h)}.
}
\references{
\insertAllCited{}
}
