% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppdist.R
\name{plotmatch}
\alias{plotmatch}
\title{Plot Optimal Matching between Two Point Patterns}
\usage{
plotmatch(
  xi,
  eta,
  dmat,
  res,
  penalty,
  p = 1,
  cols = c(2, 4),
  pchs = c(1, 1),
  cexs = c(1, 1),
  ...
)
}
\arguments{
\item{xi, eta}{objects of class \code{\link[=ppp]{ppp}}.}

\item{dmat}{a matrix specifying in its \eqn{(i,j)}-th entry the distance from the
i-th point of \eqn{\xi}{xi} to the j-th point of \eqn{\eta}{eta}.}

\item{res}{the object returned by the call to \code{\link{ppdist}} with \code{ret_matching = TRUE}.}

\item{penalty}{a positive number. The penalty for adding/deleting points.}

\item{p}{a number \eqn{>0}. The order of the TT- or RTT-distance computed.}

\item{cols, pchs, cexs}{vectors of length 2 specifying the corresponding graphic 
parameters col, pch and cex for plotting the two point patterns.}

\item{...}{further graphic parameters passed to the code that draws the line segments
between the points.}
}
\value{
Used for the side effect of plotting.
}
\description{
After calling \code{\link{ppdist}} with argument \code{ret_matching = TRUE}
in a situation where it makes sense to assign to the points of the patterns \eqn{\xi}{xi}
and \eqn{\eta}{eta} coordinates in \eqn{R^2}{R^2}, this function may be used to display
the result graphically.
}
\details{
The default use-case is to plot a matching obtained with \code{\link{ppdist}}.
       In that case \code{dmat}, \code{penalty} and \code{p} should be the same
       as in the call to \code{ppdist}. These objects are used to display additional
       information about the matching.
}
\examples{
  # See examples for ppdist

}
\seealso{
\code{\link{ppdist}}
}
\author{
Dominic Schuhmacher \email{schuhmacher@math.uni-goettingen.de}
}
