% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_hp.R
\name{ts_fil_hp}
\alias{ts_fil_hp}
\title{Hodrick-Prescott Filter}
\usage{
ts_fil_hp(lambda = 100, preserve = 0.9)
}
\arguments{
\item{lambda}{It is the smoothing parameter of the Hodrick-Prescott filter.
Lambda = 100*(frequency)^2
Correspondence between frequency and lambda values
annual => frequency = 1 // lambda = 100
quarterly => frequency = 4 // lambda = 1600
monthly => frequency = 12 // lambda = 14400
weekly => frequency = 52 // lambda = 270400
daily (7 days a week) => frequency = 365 // lambda = 13322500
daily (5 days a week) => frequency = 252 // lambda = 6812100}

\item{preserve}{value between 0 and 1. Balance the composition of observations and applied filter.
Values close to 1 preserve original values. Values close to 0 adopts HP filter values.}
}
\value{
a \code{ts_fil_hp} object.
}
\description{
This filter eliminates the cyclical component of the series, performs smoothing on it, making it more sensitive to long-term fluctuations. Each observation is decomposed into a cyclical and a growth component.
}
\examples{
# time series with noise
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2*tsd$y[9]

# filter
filter <- ts_fil_hp(lambda = 100*(26)^2)  #frequency assumed to be 26
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# plot
plot_ts_pred(y=tsd$y, yadj=y)
}
