% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_wavelet.R
\name{ts_fil_wavelet}
\alias{ts_fil_wavelet}
\title{Wavelet Filter}
\usage{
ts_fil_wavelet(filter = "haar")
}
\arguments{
\item{filter}{Availables wavelet filters: haar, d4, la8, bl14, c6}
}
\value{
a \code{ts_fil_wavelet} object.
}
\description{
Wavelet Filter
}
\examples{
# time series with noise
library(daltoolbox)
data(sin_data)
sin_data$y[9] <- 2*sin_data$y[9]

# filter
filter <- ts_fil_wavelet()
filter <- fit(filter, sin_data$y)
y <- transform(filter, sin_data$y)

# plot
plot_ts_pred(y=sin_data$y, yadj=y)
}
