% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{olympic_running}
\alias{olympic_running}
\title{Fastest running times for Olympic races}
\format{
Time series of class \code{tsibble}
}
\source{
\url{https://www.olympic.org/athletics}
}
\description{
\code{olympic_running} is a quadrennial \code{tsibble} with one value:
\tabular{ll}{
Time:      \tab Fastest running time for the event (seconds)\cr
}
}
\details{
The event is identified using two keys:
\tabular{ll}{
Length:     \tab The length of the race (meters)\cr
Sex:     \tab The sex of the event\cr
}

The data contains missing values in 1916, 1940 and 1944 due to the World Wars.
}
\examples{
library(tsibble)
olympic_running

if(requireNamespace("ggplot2")){
library(ggplot2)
olympic_running \%>\% as_tibble \%>\%
  ggplot(aes(x=Year, y = Time, colour = Sex)) +
  geom_line() +
  facet_wrap(~ Length, scales = "free_y")
}
}
\keyword{datasets}
