% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearquarter.R
\name{yearquarter}
\alias{yearquarter}
\alias{is_yearquarter}
\title{Represent year-quarter}
\usage{
yearquarter(x)

is_yearquarter(x)
}
\arguments{
\item{x}{Other object.}
}
\value{
year-quarter (\code{yearquarter}) objects.
}
\description{
\lifecycle{stable}

Create or coerce using \code{yearquarter()}.
}
\section{Display}{

Use \code{format()} to display \code{yearweek}, \code{yearmonth}, and \code{yearquarter} objects
in required formats.
Please see \code{\link[=strptime]{strptime()}} details for supported conversion specifications.
}

\examples{
# coerce POSIXct/Dates to yearquarter
x <- seq(as.Date("2016-01-01"), as.Date("2016-12-31"), by = "1 quarter")
yearquarter(x)

# parse characters
yearquarter(c("2018 Q1", "2018 Qtr1", "2018 Quarter 1"))

# creat an empty yearquarter container
yearquarter()

# seq() and arithmetic
qtr <- yearquarter("2017 Q1")
seq(qtr, length.out = 10, by = 1) # by 1 quarter
qtr + 0:9

# display formats
format(qtr, format = "\%y Qtr\%q")

# units since 1970 Q1
as.double(yearquarter("1969 Q1") + 0:8)
}
\seealso{
Other index functions: 
\code{\link{yearmonth}()},
\code{\link{yearweek}()}
}
\concept{index functions}
