% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-tsibble.R, R/ts2tsibble.R
\name{as_tsibble}
\alias{as_tsibble}
\alias{as_tsibble.data.frame}
\alias{as_tsibble.ts}
\alias{as_tsibble.mts}
\alias{as_tsibble.hts}
\title{Coerce to a tsibble object}
\usage{
as_tsibble(
  x,
  key = NULL,
  index,
  regular = TRUE,
  validate = TRUE,
  .drop = TRUE,
  ...
)

\method{as_tsibble}{data.frame}(
  x,
  key = NULL,
  index,
  regular = TRUE,
  validate = TRUE,
  .drop = TRUE,
  ...
)

\method{as_tsibble}{ts}(x, ..., tz = "UTC")

\method{as_tsibble}{mts}(x, ..., tz = "UTC", pivot_longer = TRUE, gather = deprecated())
}
\arguments{
\item{x}{Other objects to be coerced to a tsibble (\code{tbl_ts}).}

\item{key}{Unquoted variable(s) that uniquely determine time indices. \code{NULL} for
empty key, and \code{c()} for multiple variables. It works with tidy selector
(e.g. \code{\link[dplyr:starts_with]{dplyr::starts_with()}}).}

\item{index}{A bare (or unquoted) variable to specify the time index variable.}

\item{regular}{Regular time interval (\code{TRUE}) or irregular (\code{FALSE}). The
interval is determined by the greatest common divisor of index column, if \code{TRUE}.}

\item{validate}{\code{TRUE} suggests to verify that each key or each combination
of key variables leads to unique time indices (i.e. a valid tsibble). If you
are sure that it's a valid input, specify \code{FALSE} to skip the checks.}

\item{.drop}{If \code{TRUE}, empty key groups are dropped.}

\item{...}{Other arguments passed on to individual methods.}

\item{tz}{Time zone. May be useful when a \code{ts} object is more frequent than
daily.}

\item{pivot_longer}{\code{TRUE} gives a "longer" form of the data, otherwise as is.}

\item{gather}{\lifecycle{defunct} Please use \code{pivot_longer} instead.}
}
\value{
A tsibble object.
}
\description{
\lifecycle{stable}
}
\examples{
# coerce tibble to tsibble w/o a key
tbl1 <- tibble(
  date = as.Date("2017-01-01") + 0:9,
  value = rnorm(10)
)
as_tsibble(tbl1)
# supply the index to suppress the message
as_tsibble(tbl1, index = date)

# coerce tibble to tsibble with a single variable for key
# "date" is automatically considered as the index var, and "group" is the key
tbl2 <- tibble(
  mth = rep(yearmonth("2017-01") + 0:9, 3),
  group = rep(c("x", "y", "z"), each = 10),
  value = rnorm(30)
)
as_tsibble(tbl2, key = group)
as_tsibble(tbl2, key = group, index = mth)

# create a tsibble with multiple variables for key
tbl3 <- tibble(
  mth = rep(yearmonth("2010 Jan") + 0:8, each = 3),
  xyz = rep(c("x", "y", "z"), each = 9),
  abc = rep(letters[1:3], times = 9),
  value = rnorm(27)
)
as_tsibble(tbl3, key = c(xyz, abc))
# coerce ts to tsibble
as_tsibble(AirPassengers)
as_tsibble(sunspot.year)
as_tsibble(sunspot.month)
as_tsibble(austres)
# coerce mts to tsibble
z <- ts(matrix(rnorm(300), 100, 3), start = c(1961, 1), frequency = 12)
as_tsibble(z)
as_tsibble(z, pivot_longer = FALSE)
}
\seealso{
\link{tsibble}
}
