% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.1.0.R
\name{tsdecomp}
\alias{tsdecomp}
\alias{print.tsdecomp}
\alias{plot.tsdecomp}
\title{Decompose a Time Series}
\usage{
tsdecomp(
  x,
  type = c("additive", "multiplicative"),
  trend.method = c("lm", "loess"),
  tcc.order = 3,
  x.name = NULL,
  show.plot = TRUE
)

\method{print}{tsdecomp}(x, ...)

\method{plot}{tsdecomp}(x, ...)
}
\arguments{
\item{x}{a time series for which decomposition is required or a `\code{tsdecomp}` object.}

\item{type}{type of the time series components. Available options are `\code{additive}` and `\code{multiplicative}`. Can be abbreviated. Default is `\code{additive}`.}

\item{trend.method}{estimating method of the trend. Available options are `\code{lm}` (linear) and `\code{loess}` (non-linear). Default is `\code{lm}`.}

\item{tcc.order}{moving average order for the estimation of the trend-cycle component.}

\item{x.name}{name of the series. If omitted here, the series name found by \code{tsname()} will be taken over here. If \code{tsname()} is \code{NULL}, the variable name will be used instead. Default is \code{NULL}.}

\item{show.plot}{logical. If \code{TRUE}, forecasting plot will be displayed directly. Default is \code{TRUE}.}

\item{...}{parameter values that can affect the time series decomposition plots.}
}
\value{
An object of class "\code{tsdecomp}" with following components:

\item{x}{original series data}

\item{x.time}{list of time in which the series values were observed.}

\item{x.timegap}{time gap between the series and forecasted values.}

\item{x.name}{name of the time series for which forecasts was requested.}

\item{trend}{value of the trend component for each observation.}

\item{cycle}{value of the cyclical component for each observation.}

\item{trend.cycle}{trend-cyclical component value of each observation.}

\item{detrended}{value of each observation after removing the trend component.}

\item{seasonal}{value of the seasonal component for each observation.}

\item{seasonal.adjusted}{value of each observation after removing the seasonal component}

\item{random}{value of the irregular component for each observation.}

\item{seasonal.effect}{value expressing the estimated overall effect of each season in the time series.}

\item{type}{type of the time series decomposition.}
}
\description{
Decompose a time series into trend, cyclical, seasonal and irregular components. Deals with additive or multiplicative components.
}
\details{
The additive model used is:
\deqn{Y_t = T_t + C_t + S_t + I_t}    
The multiplicative model used is:
\deqn{Y_t = T_t \cdot C_t \cdot S_t \cdot I_t}    
The function first determines the trend-cycle component using a moving average, and removes it from the time series. Then, the seasonal figure is computed by averaging, for each time unit, over all periods. The seasonal figure is then centred. Finally, the error component is determined by removing trend and seasonal figure (recycled as needed) from the original time series.
\cr\cr This only works well if `\code{x}` covers an integer number of complete periods.

The function `\code{plot}` generates the following plots: 
\tabular{lcl}{\code{Trend} \tab \tab a time series line plot together with a trend line. \cr
\code{Trend-Cycles} \tab \tab a time series line plot together with the trend-cycle component (moving averages). \cr
\code{Cycles} \tab \tab a line plot of the trend-cycle component (moving averages). \cr
\code{Detrended} \tab \tab a line plot of the time series after removing the trend component. \cr
\code{Irregular} \tab \tab a line plot of the irregular component. \cr
\code{Seasonally Adjusted} \tab \tab a line plot of the time series after removing the seasonal component. \cr
\code{Seasonal} \tab \tab a line plot of the seasonal component. \cr
\code{Seasonal Effect} \tab \tab a line plot of the overall estimated effect of each season in the time series. \cr
}
}
\examples{
tsdecomp(airport$Travellers, type = "multiplicative")
}
\references{
Hyndman, R. J., & Athanasopoulos, G. (2021). Forecasting: Principles and practice (3rd ed.). OTexts. \cr \url{https://otexts.com/fpp3/}

Kendall, M., & Stuart, A. (1983) The Advanced Theory of Statistics, Vol.3, Griffin. pp. 410-414.
}
\author{
Ka Yui Karl Wu
}
