% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{max_level_shift}
\alias{max_level_shift}
\alias{max_var_shift}
\alias{max_kl_shift}
\title{Time series features based on sliding windows}
\usage{
max_level_shift(x, width = ifelse(frequency(x) > 1, frequency(x), 10))

max_var_shift(x, width = ifelse(frequency(x) > 1, frequency(x), 10))

max_kl_shift(x, width = ifelse(frequency(x) > 1, frequency(x), 10))
}
\arguments{
\item{x}{a univariate time series}

\item{width}{size of sliding window}
}
\value{
A vector of 2 values: the size of the shift, and the time index of the shift.
}
\description{
Computes feature of a time series based on sliding (overlapping) windows.
\code{max_level_shift} finds the largest mean shift between two consecutive windows.
\code{max_var_shift} finds the largest var shift between two consecutive windows.
\code{max_kl_shift} finds the largest shift in Kulback-Leibler divergence between
two consecutive windows.
}
\details{
Computes the largest level shift and largest variance shift in sliding mean calculations
}
\author{
Earo Wang and Rob J Hyndman
}
