% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specialfun.r
\name{outidentify}
\alias{outidentify}
\title{\code{outidentify} performs one iteration of Wei's iterative procedure to identify impact, locations and type 
 of outliers in arma processes}
\usage{
outidentify(x, object, alpha = 0.05, robust = FALSE)
}
\arguments{
\item{x}{vector, the time series}

\item{object}{output of a model fit with the function  arima  (from stats)}

\item{alpha}{the level of the tests for deciding which value is to be considered an outlier}

\item{robust}{logical, should the standard error be computed robustly?}
}
\value{
out list with   elements
\item{outlier}{matrix with time index (ind), type of outlier  (1 = AO, 2 = IO) and value of test statistic (lambda)} 
\item{arima.out}{output of final arima model where the outliers are incorporated as fixed regressors    }
}
\description{
\code{outidentify} performs one iteration of Wei's iterative procedure to identify impact, locations and type 
 of outliers in arma processes
}
\examples{
data(SPRUCE)
out <- arima(SPRUCE,order=c(2,0,0))
out2 <- outidentify(SPRUCE,out,alpha=0.05, robust = FALSE)
}
