% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/VAR.sim.R
\name{VAR.boot}
\alias{VAR.boot}
\title{Bootstrap a Vector Autoregressive (VAR) model}
\usage{
VAR.boot(VARobject, boot.scheme = c("resample", "wild1", "wild2", "check"),
  seed)
}
\arguments{
\item{VARobject}{Object of class \code{ VAR} generated by function
\code{\link{lineVar}}}

\item{boot.scheme}{The bootstrap scheme. See details.}

\item{seed}{Optional. Seed for the random resampling function.}

\item{\dots}{Further arguments passed to the underlying (un-exported)
\code{VAR.gen} function}
}
\value{
A matrix with the bootstraped series.
}
\description{
Recursive bootstrap of a Vector VAR (VAR)
}
\details{
The function bootstraps a given model. This is done on a object generated by
lineVar. A simple residual recursive bootstrap is done.
}
\examples{
##Bootstrap a VAR
data(zeroyld)
mod <- lineVar(data=zeroyld,lag=1)
VAR.boot(mod)
}
\author{
Matthieu Stigler
}
\keyword{bootstrap}
\keyword{ts}

