% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_item_metadata.R
\name{get_item_metadata}
\alias{get_item_metadata}
\title{Retrieve metadata for a NHS TRUD item}
\usage{
get_item_metadata(item, TRUD_API_KEY = NULL, latest_only = FALSE)
}
\arguments{
\item{item}{An integer, the item to be downloaded.}

\item{TRUD_API_KEY}{A string. The name of an environmental variable
containing your TRUD API key. If \code{NULL} (default) this is assumed to be
called \code{TRUD_API_KEY}.}

\item{latest_only}{If \code{TRUE}, only metadata pertaining to the latest item
release will be retrieved. By default this is set to \code{FALSE}.}
}
\value{
A list.
}
\description{
Sends a request to the release list endpoint, returning a list of metadata
pertaining to the specified NHS TRUD item.
}
\examples{
\dontrun{
 # Get metadata for Community Services Data Set pre-deadline extract XML Schema
 get_item_metadata(394) |>
   purrr::map_at("releases", \(release) purrr::map(release, names))

# Include metadata for any previous releases using `latest_only = FALSE`
get_item_metadata(394, latest_only = FALSE) |>
   purrr::map_at("releases", \(release) purrr::map(release, names))
}

# An informative error is raised if your API key is invalid or missing
try(download_item(394, TRUD_API_KEY = "INVALID_API_KEY"))
}
