% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triptych_murphy.R
\name{murphy}
\alias{murphy}
\alias{as_murphy}
\title{Evaluation of forecasts using Murphy curves}
\usage{
murphy(x, y_var = "y", ref_var = "ref", ..., y = NULL, ref = NULL)

as_murphy(x, r)
}
\arguments{
\item{x}{A data frame, list, matrix, or other object that can be coerced to a tibble. Contains numeric forecasts, and observations (optional).}

\item{y_var}{A variable in \code{x} that contains observations. Specified as the argument \code{var}in \code{\link[dplyr:pull]{dplyr::pull()}}.}

\item{ref_var}{A variable in \code{x} that contains reference forecasts. Specified as the argument \code{var} in \code{\link[dplyr:pull]{dplyr::pull()}}). Ignored, if the default name is not present in \code{x}.}

\item{...}{Unused.}

\item{y}{A numeric vector of observations. If supplied, overrides \code{y_var}. Otherwise, defaults to \code{dplyr::pull(x, y_var)}.}

\item{ref}{A numeric vector of reference forecasts. If supplied, overrides \code{ref_var}. Otherwise, ignored (see \code{ref_var}) or \code{dplyr::pull(x, ref_var)}.}

\item{r}{A reference triptych_murphy object whose attributes are used for casting.}
}
\value{
A \code{triptych_murphy} object, that is a \code{vctrs_vctr} subclass, and has
a length equal to number of forecasting methods supplied in \code{x}. Each entry
is named according to the corresponding forecasting method,
and contains a list of named objects:
\itemize{
\item \code{estimate}: A data frame with the threshold and corresponding mean score values.
\item \code{region}: Either an empty list, or a data frame of point confidence intervals
added by \code{\link[=add_confidence]{add_confidence()}}.
\item \code{x}: The numeric vector of original forecasts.
}
Access is most convenient through \code{\link[=estimates]{estimates()}}, \code{\link[=regions]{regions()}}, and \code{\link[=forecasts]{forecasts()}}.
}
\description{
A Murphy curve visualizes economic utility by displaying the mean elementary
scores across all threshold values.
}
\examples{
data(ex_binary, package = "triptych")

mr <- murphy(ex_binary)
mr

# 1. Choose 4 predictions
# 2. Visualize
# 3. Adjust the title of the legend
mr[c(1, 3, 6, 9)] |>
  autoplot() +
  ggplot2::guides(colour = ggplot2::guide_legend("Forecast"))
  
# Build yourself using accessors
library(ggplot2)
df_est <- estimates(mr[c(1, 3, 6, 9)])
ggplot(df_est) +
  geom_path(aes(x = knot, y = mean_score, col = forecast))

}
\seealso{
Accessors: \code{\link[=estimates]{estimates()}}, \code{\link[=regions]{regions()}}, \code{\link[=forecasts]{forecasts()}}, \code{\link[=observations]{observations()}}

Adding uncertainty quantification: \code{\link[=add_confidence]{add_confidence()}}

Visualization: \code{\link[=plot.triptych_murphy]{plot.triptych_murphy()}}, \code{\link[=autoplot.triptych_murphy]{autoplot.triptych_murphy()}}
}
