% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colours.R
\name{oc.theme}
\alias{oc.theme}
\alias{oc.colors}
\title{SeaWiFS ocean colour colours}
\usage{
oc.theme(x = 50)

oc.colors(n)
}
\arguments{
\item{x}{Number of colours to generate as part of a theme}

\item{n}{Number of colours to generate}
}
\value{
A set of colours or a theme object.
}
\description{
Generate ocean colour colours, using the SeaWiFS scheme
}
\details{
This is a high-contrast palette, log-scaled originally for ocean
chlorophyll.
}
\examples{
\dontrun{
 oc.colors(10)
 library(lattice)
 trellis.par.set(oc.theme())
 d <- data.frame(x=1:10, y=rnorm(10), tms=Sys.time() + 1:10, id=gl(2, 5))
sp::coordinates(d) <- ~x+y
## this avoids complaints later, but these are not real track data (!)
sp::proj4string(d) <- sp::CRS("+proj=laea +ellps=sphere", doCheckCRSArgs = FALSE)
tr <- trip(d, c("tms", "id"))

 tg <- tripGrid(tr)
 spplot(tg)
}
}
\seealso{
Similar functions in sp \code{\link[sp]{spplot}},
\code{\link[sp]{bpy.colors}}
}
\keyword{color}
