% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unify_gbm.R
\name{gbm.unify}
\alias{gbm.unify}
\title{Unify GBM model}
\usage{
gbm.unify(gbm_model, data)
}
\arguments{
\item{gbm_model}{An object of \code{gbm} class. At the moment, models built on data with categorical features
are not supported - please encode them before training.}

\item{data}{Reference dataset. A \code{data.frame} or \code{matrix} with the same columns as in the training set of the model. Usually dataset used to train model.}
}
\value{
a unified model representation - a \code{\link{model_unified.object}} object
}
\description{
Convert your GBM model into a standardized representation.
The returned representation is easy to be interpreted by the user and ready to be used as an argument in \code{treeshap()} function.
}
\examples{
\donttest{
library(gbm)
data <- fifa20$data[colnames(fifa20$data) != 'work_rate']
data['value_eur'] <- fifa20$target
gbm_model <- gbm::gbm(
             formula = value_eur ~ .,
             data = data,
             distribution = "gaussian",
             n.trees = 20,
             interaction.depth = 4,
             n.cores = 1)
unified_model <- gbm.unify(gbm_model, data)
shaps <- treeshap(unified_model, data[1:2,])
plot_contribution(shaps, obs = 1)
}
}
\seealso{
\code{\link{lightgbm.unify}} for \code{\link[lightgbm:lightgbm]{LightGBM models}}

\code{\link{xgboost.unify}} for \code{\link[xgboost:xgboost]{XGBoost models}}

\code{\link{ranger.unify}} for \code{\link[ranger:ranger]{ranger models}}

\code{\link{randomForest.unify}} for \code{\link[randomForest:randomForest]{randomForest models}}
}
