% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune_se.R
\name{prune_se}
\alias{prune_se}
\title{Prune an \code{rpart} object}
\usage{
prune_se(object, prune = TRUE, se = 1)
}
\arguments{
\item{object}{An object that inherits from class \code{"rpart"}.}

\item{prune}{Logical indicating whether or not to return the pruned decision
tree. Default is \code{TRUE}. If \code{FALSE}, the optimal value of the 
cost-complexity parameter is returned instead.}

\item{se}{Numeric specifying the number of standard errors to use when 
pruning the tree. Default is \code{1}, which corresponds to the 1-SE rule
described in Breiman et al. (1984).}
}
\value{
Either an object that inherits from class \code{"rpart"} (ideally, 
one that's been simplified using cost-complexity pruning with the 1-SE rule)
or a numeric value representing the cost-complexity parameter to use for 
pruning.
}
\description{
Prune an \code{rpart} object using the standard error (SE) of the 
cross-validation results.
}
\references{
Breiman, L., Friedman, J., and Charles J. Stone, R. A. O. (1984). 
Classification and Regression Trees. The Wadsworth and Brooks-Cole 
statistics-probability series. Taylor & Francis.
}
\seealso{
\code{\link[rpart]{prune}}
}
