% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treemapify.R
\name{treemapify}
\alias{treemapify}
\alias{treemapify_fixed}
\title{Generate a treemap layout.}
\usage{
treemapify(data, area, subgroup, subgroup2, subgroup3, fixed = FALSE)

treemapify_fixed(...)
}
\arguments{
\item{data}{A tidy data frame.}

\item{area}{Name of the variable (a column in `data`) to be mapped to the
area of treemap tiles.}

\item{subgroup, subgroup2, subgroup3}{Optionally, names of variables
(columns in `data) by which the tiles should be grouped, at up to three
nested levels.}

\item{fixed}{If true, the alternative 'fixed' algorithm will be used (see
Details).}

\item{...}{Other arguments to be passed to `treemapify`.}
}
\description{
`treemapify` returns a data frame of tile coordinates for a treemap layout
of a set of observations. This is only useful if you wish to draw the
treemap without the help of the `ggplot2` geoms, or for some edge cases such
as creating interactive treemaps with 'R Shiny' (see e.g.
\url{https://stackoverflow.com/q/45021775}). The easiest way to draw a
treemap with the 'treemapify' package is to use the provided 'ggplot2'
geoms, such as `geom_treemap`.

`data` must be a tidy data frame, i.e. each row must represent a single
observation and each column a single variable. You must provide the name of
the variable that will be represented by the area of each treemap tile with
`area`. Optionally, you can also select up to three variables (with
`subgroup`, `subgroup2` and `subgroup3`) to generate a layout in which the
tiles are clustered into subgroups nested up to three levels deep.

Two layout algorithms are provided. With the default 'squarified' algorithm,
the priority is ensuring the tiles have an aesthetically pleasing aspect
ratio; that is, they are not too narrow or too short. In this algorithm,
tile placement proceeds from the bottom left corner, moving alternately
rightwards and upwards until all tiles are placed. See Bruls et al. (1999)
for the full algorithm.

With the alternative 'fixed' layout algorithm (`fixed = TRUE`), the plot area
is divided into vertical columns, which are filled from left to right with an
equal number of tiles beginning at the bottom of each column. Unlike the
default 'squarified' algorithm, with the 'fixed' algorithm the relative
positions of the tiles are fixed by their order in the input data frame. This
can result in aesthetically unpleasing tiles, but it allows side-by-side
comparisons or animations to be created.

`treemapify_fixed` is an alias for `treemapify(fixed = TRUE)`.
}
\details{
`treemapify` is for generating a data frame of raw treemap coordinates. If
you want to draw a treemap with 'ggplot2', use `geom_treemap` instead.
}
\examples{

treemapify(G20, area = "gdp_mil_usd")

}
\references{
Bruls, M., Huizing, K., & van Wijk, J. (1999). Squarified Treemaps (pp.
33-42).Proceedings of the Joint Eurographics and IEEE TCVG Symposium on
Visualization. \url{http://www.win.tue.nl/~vanwijk/stm.pdf}
}
\seealso{
geom_treemap
}
