% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip-methods.R
\name{rmClade}
\alias{rmClade}
\title{Remove a clade from a tree}
\usage{
rmClade(tree, id)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{id}{node ID parent of clade to be removed}
}
\description{
Returns a tree with a clade removed
}
\details{
Inverse function of \code{getSubtree()}. Takes a tree
and removes a clade based on an internal node specified. Node
is specified with \code{id}, all descending nodes and tips are removed.
The resulting tree will replace the missing clade with a tip of \code{id}.
}
\examples{
library(treeman)
t1 <- randTree(100)
# remove a clade
t2 <- rmClade(t1, 'n2')
summary(t1)
summary(t2)
}
\seealso{
\code{\link{addClade}}, \code{\link{getSubtree}}, \code{\link{rmTips}}
\url{https://github.com/DomBennett/treeman/wiki/manip-methods}
}
