% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip-methods.R
\name{ultrTree}
\alias{ultrTree}
\title{Make tree ultrametric}
\usage{
ultrTree(tree)
}
\arguments{
\item{tree}{\code{TreeMan} object}
}
\description{
Returns a tree with all tips ending at time 0
}
\details{
Re-calculates the branch lengths in the tree so that all
tips are brought to the same time point: all species are extant.
}
\examples{
library(treeman)
tree <- randTree(10)
(getDcsd(tree))  # list all extinct tips
tree <- ultrTree(tree)
(getDcsd(tree))  # list all extinct tips
}
\seealso{
\url{https://github.com/DomBennett/treeman/wiki/manip-methods}
}
