% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nd-methods.R
\name{getNdSlt}
\alias{getNdSlt}
\title{Get a node slot}
\usage{
getNdSlt(tree, slt_nm, id)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{slt_nm}{slot name}

\item{id}{node id}
}
\description{
Returns the value of named slot.
}
\details{
Returned object depends on name, either character, vector or numeric.
Default node slots are: id, spn, prid, ptid and txnym. If slot is empty, returns NA.
}
\examples{
library(treeman)
tree <- randTree(10)
getNdSlt(tree, slt_nm='spn', id='t1')  # return span of t1
}
\seealso{
\code{\link{getNdsSlt}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
