% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baumWelch.R
\name{baumWelchRecursion}
\alias{baumWelchRecursion}
\title{Implementation of the Baum Welch Algorithm as a special case of EM algorithm}
\usage{
baumWelchRecursion(hmm, observation, kn_states = NULL,
  kn_verify = NULL)
}
\arguments{
\item{hmm}{hmm Object of class List given as output by \code{\link{initHMM}}}

\item{observation}{A list consisting "k" vectors for "k" features, each vector being a character series of discrete emmision values at different nodes serially sorted by node number}

\item{kn_states}{(Optional) A (L * 2) dataframe where L is the number of training nodes where state values are known. First column should be the node number and the second column being the corresponding known state values of the nodes}

\item{kn_verify}{(Optional) A (L * 2) dataframe where L is the number of validation nodes where state values are known. First column should be the node number and the second column being the corresponding known state values of the nodes}
}
\value{
List containing estimated Transition and Emission probability matrices
}
\description{
\code{\link{baumWelch}} recursively calls this function to give a final estimate of parameters for tree HMM
Uses Parallel Processing to speed up calculations for large data. Should not be used directly.
}
\examples{
tmat = matrix(c(0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0),
               5,5, byrow= TRUE ) #for "X" (5 nodes) shaped tree
hmmA = initHMM(c("P","N"),list(c("L","R")), tmat) #one feature with two discrete levels "L" and "R"
obsv = list(c("L","L","R","R","L")) #emissions for the one feature for the 5 nodes in order 1:5
kn_st = data.frame(node=c(2),state=c("P"),stringsAsFactors = FALSE)
                   #state at node 2 is known to be "P"
kn_vr = data.frame(node=c(3,4,5),state=c("P","N","P"),stringsAsFactors = FALSE) 
                   #state at node 3,4,5 are "P","N","P" respectively
newparam= baumWelchRecursion(hmmA,obsv,kn_st, kn_vr)
}
\seealso{
\code{\link{baumWelch}}
}
