% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{transition.matrix}
\alias{transition.matrix}
\title{Makes a transition matrix}
\usage{
transition.matrix(type, states, rates = runif, self = TRUE, ...)
}
\arguments{
\item{type}{the type of transition matrix, either "equal rates", "stepwise", "symmetric", or  "all rates different". See details.}

\item{states}{the number of states.}

\item{rates}{either a fixed value for a rate to attribute to each possible transitions or a \code{function} to generate the rates (default is \code{\link[stats]{runif}}). See details.}

\item{self}{logical, whether to allow reverting states (i.e. transition rates from state A to the same state A; \code{TRUE}; default) or not (\code{FALSE}).}

\item{...}{if \code{rates} is a function, any optional arguments to be passed to it.}
}
\value{
Returns a squared \code{"matrix"}.
}
\description{
Utility function for generating discrete characters evolution transition matrices.
}
\details{
The following transition rate matrices are currently implemented:
\itemize{
     \item "equal rates" where all transitions are equal (including no transition if \code{self = TRUE}).
     \item "stepwise" transitions are allowed only in a step wise way (e.g. state 1 to 2 and 2 to 3 are allowed but not 1 to 3).
     \item "symmetric" where transitions between states are all different but not directional (e.g. the change of state 1 to 2 is equal to 2 to 1). If \code{self = TRUE}, the non transitions (e.g. from state 1 to 1) are equal.
     \item "all rates different" where all transitions are different. Note that if rates is a give value (rather than a function), then all rates are actually equal.
}

If \code{rates} is a function that generates negative values or a negative value, the output transition matrix always returns absolute values.
}
\examples{
## A two states equal rates matrix with a rate of 1
## and no stationary rates (no probability of staying in the same state)
transition.matrix(type = "equal rates", states = 2, rates = 1, self = FALSE)

## Two different 6 states stepwise matrix with a random absolute normal rate
transition.matrix(type = "stepwise", states = 6, rates = rnorm)
transition.matrix(type = "stepwise", states = 6, rates = rnorm)

}
\seealso{
\code{\link{make.traits}} \code{\link{discrete.process}}
}
\author{
Thomas Guillerme
}
