% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_of_survival.R
\name{probability_of_survival}
\alias{probability_of_survival}
\title{Calculate Probability of Survival Using TRISS Method}
\usage{
probability_of_survival(trauma_type, age, rts, iss)
}
\arguments{
\item{trauma_type}{Character vector indicating the type of trauma ("Blunt" or
"Penetrating"). Different methods exist for calculating probability of survival
for burn patients, and so these records are excluded here.}

\item{age}{Numeric vector indicating the patient's age in years.}

\item{rts}{Numeric vector indicating the patient's Revised Trauma Score
(RTS).}

\item{iss}{Numeric vector indicating the patient's Injury Severity Score
(ISS).}
}
\value{
Numeric vector of probabilities of survival (Ps) expressed as
percentages on a scale from 0 to 1.
}
\description{
This function calculates the probability of survival (Ps) for trauma patients
based on the Trauma and Injury Severity Score (TRISS) methodology. TRISS
combines physiological and anatomical data to predict survival likelihood
using a logistic regression model. The function incorporates trauma type,
patient age, Revised Trauma Score (RTS), and Injury Severity Score (ISS) into
the calculation. Probability of survival is expressed as a percentage.
}
\examples{
# Example usage:
trauma_data <- data.frame(
  Trauma_Type = c("Blunt", "Penetrating"),
  Patient_Age_Years = c(30, 60),
  RTS = c(7.84, 6.90),
  ISS = c(10, 25)
)

result <- trauma_data |>
  dplyr::mutate(Ps = probability_of_survival(
    trauma_type = Trauma_Type,
    age = Patient_Age_Years,
    rts = RTS,
    iss = ISS
  ))

}
\author{
Nicolas Foss, Ed.D., MS
}
