% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate-is-call.R
\name{is_translate_call}
\alias{is_translate_call}
\title{Identify Calls to Function translate()}
\usage{
is_translate_call(x, strict = TRUE)
}
\arguments{
\item{x}{Any \R object.}

\item{strict}{A non-\link[base:NA]{NA} logical value. Must the \code{transltr}
namespace be explicitly stated (with operator \code{::}) in the call? See
Details.}
}
\value{
A logical value.
}
\description{
Check whether an object is a \code{\link{call}} to \code{\link[=translate]{translate()}}.

\strong{Arguments listed below are not explicitly validated for efficiency.}
}
\details{
An \emph{implicit} call does not specify the namespace, i.e. \code{translate()}. It
may refer to \emph{any} such function and may not correspond to \code{\link[=translate]{translate()}}.
This depends on the user's intents at compile time and on the
\link[=search]{search} path at runtime.

An \emph{explicit} call includes the namespace, i.e. \code{transltr::translate()}.
There is no ambiguity.

\R is sometimes an odd language and this function covers some unusual use
cases. See Examples below. By design, it \strong{does not} detect calls to method
\code{\link[=Translator]{Translator$translate()}}. Using the latter is discouraged.
}
\keyword{internal}
