% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rag.R
\name{rag}
\alias{rag}
\title{Retrieval-augmented Generation (RAG)}
\usage{
rag(
  text = NULL,
  path = NULL,
  transformer = c("LLAMA-2", "Mistral-7B", "OpenChat-3.5", "Orca-2", "Phi-2",
    "TinyLLAMA"),
  prompt = "You are an expert at extracting themes across many texts",
  query,
  response_mode = c("accumulate", "compact", "no_text", "refine", "simple_summarize",
    "tree_summarize"),
  similarity_top_k = 5,
  device = c("auto", "cpu", "cuda"),
  keep_in_env = TRUE,
  envir = 1,
  progress = TRUE
)
}
\arguments{
\item{text}{Character vector or list.
Text in a vector or list data format.
\code{path} will override input into \code{text}
Defaults to \code{NULL}}

\item{path}{Character.
Path to .pdfs stored locally on your computer.
Defaults to \code{NULL}}

\item{transformer}{Character.
Large language model to use for RAG.
Available models include:

\describe{

\item{"LLAMA-2"}{The largest model available (13B parameters) but also the most challenging to get up and running for Mac and Windows. Linux operating systems run smooth. The challenge comes with installing the \{llama-cpp-python\} module. Currently, we do not provide support for Mac and Windows users}

\item{"Mistral-7B"}{Mistral's 7B parameter model that serves as a high quality but more computationally expensive (more time consuming)}

\item{"Orca-2"}{More documentation soon...}

\item{"Phi-2"}{More documentation soon...}

\item{"TinyLLAMA"}{Default. A smaller, 1B parameter version of LLAMA-2 that offers fast inference with reasonable quality}

}}

\item{prompt}{Character (length = 1).
Prompt to feed into TinyLLAMA.
Defaults to \code{"You are an expert at extracting emotional themes across many texts"}}

\item{query}{Character.
The query you'd like to know from the documents.
Defaults to \code{prompt} if not provided}

\item{response_mode}{Character (length = 1).
Different responses generated from the model.
See documentation \href{https://docs.llamaindex.ai/en/stable/module_guides/deploying/query_engine/response_modes.html}{here}

Defaults to \code{"tree_summarize"}}

\item{similarity_top_k}{Numeric (length = 1).
Retrieves most representative texts given the \code{query}.
Larger values will provide a more comprehensive response but at
the cost of computational efficiency; small values will provide
a more focused response at the cost of comprehensiveness.
Defaults to \code{5}.

Values will vary based on number of texts but some suggested values might be:

\describe{

\item{40-60}{Comprehensive search across all texts}

\item{20-40}{Exploratory with good trade-off between comprehensive and speed}

\item{5-15}{Focused search that should give generally good results}

}

These values depend on the number and quality of texts. Adjust as necessary}

\item{device}{Character.
Whether to use CPU or GPU for inference.
Defaults to \code{"auto"} which will use
GPU over CPU (if CUDA-capable GPU is setup).
Set to \code{"cpu"} to perform over CPU}

\item{keep_in_env}{Boolean (length = 1).
Whether the classifier should be kept in your global environment.
Defaults to \code{TRUE}.
By keeping the classifier in your environment, you can skip
re-loading the classifier every time you run this function.
\code{TRUE} is recommended}

\item{envir}{Numeric (length = 1).
Environment for the classifier to be saved for repeated use.
Defaults to the global environment}

\item{progress}{Boolean (length = 1).
Whether progress should be displayed.
Defaults to \code{TRUE}}
}
\value{
Returns response from TinyLLAMA
}
\description{
Performs retrieval-augmented generation \{llama-index\}

Currently limited to the TinyLLAMA model
}
\section{Data Privacy}{

  All processing is done locally with the downloaded model,
  and your text is never sent to any remote server or third-party.
}

\examples{
# Load data
data(neo_ipip_extraversion)

# Example text
text <- neo_ipip_extraversion$friendliness[1:5]

\dontrun{
rag(
 text = text,
 query = "What themes are prevalent across the text?",
 response_mode = "tree_summarize",
 similarity_top_k = 5
)}

}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
