% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transGFM.R
\name{transGFM_multi}
\alias{transGFM_multi}
\title{Multiple source transfer learning for generalized factor models}
\usage{
transGFM_multi(
  source_data_list,
  target_data,
  r,
  data_type = "count",
  method = "AD",
  lambda_seq = seq(0, 10, by = 1),
  K_cv = 3,
  sigma2 = 1,
  max_iter_cjmle = 30,
  max_iter_refine = 30,
  max_iter_nuclear = 100,
  verbose = FALSE
)
}
\arguments{
\item{source_data_list}{List of source data matrices (may contain missing values)}

\item{target_data}{Target data matrix (complete)}

\item{r}{Number of factors}

\item{data_type}{Type of data: "continuous", "count", or "binary"}

\item{method}{Fusion method: "AD" (Average-Debias) or "DA" (Debias-Average)}

\item{lambda_seq}{Sequence of lambda values for CV}

\item{K_cv}{Number of CV folds}

\item{sigma2}{Variance parameter for continuous data}

\item{max_iter_cjmle}{Maximum iterations for CJMLE}

\item{max_iter_refine}{Maximum iterations for refinement}

\item{max_iter_nuclear}{Maximum iterations for nuclear MLE}

\item{verbose}{Print progress information}
}
\value{
List containing final estimate and intermediate results
}
\description{
Multiple source transfer learning for generalized factor models
}
\examples{
\donttest{
# Generate Poisson data
set.seed(2025)

# Generate 3 source datasets (100 x 100 with different missing rates)
n1 <- 100; p1 <- 100; r <- 2
source_list <- list()
F_s <- matrix(runif(n1 * r, min = -2, max = 2), n1, r)
B_s <- matrix(runif(p1 * r, min = -2, max = 2), p1, r)
M_s <- F_s \%*\% t(B_s)
for (s in 1:3) {
  X_s <- matrix(rpois(n1 * p1, exp(M_s)), n1, p1)

  # Add missing values (10\%, 12\%, 14\% for sources 1-3)
  missing_rate <- 0.1 + (s - 1) * 0.02
  n_missing <- floor(n1 * p1 * missing_rate)
  missing_idx <- sample(n1 * p1, n_missing)
  X_s[missing_idx] <- NA

  source_list[[s]] <- X_s
}

# Target data (50 x 50, complete)
n0 <- 50; p0 <- 50
M_target_true <- M_s[1:n0, 1:p0]
X_target <- matrix(rpois(n0 * p0, exp(M_target_true)), n0, p0)

# Run transGFM_multi with AD method
result_AD <- transGFM_multi(
  source_data_list = source_list,
  target_data = X_target,
  r = 2,
  data_type = "count",
  method = "AD",
  lambda_seq = seq(0, 5, by = 1),
  K_cv = 3,
  verbose = FALSE
)

# Run transGFM_multi with DA method
result_DA <- transGFM_multi(
  source_data_list = source_list,
  target_data = X_target,
  r = 2,
  data_type = "count",
  method = "DA",
  verbose = FALSE
)

# Compare results
print(paste("AD method error:", relative_error(result_AD$M_trans, M_target_true)))
print(paste("DA method error:", relative_error(result_DA$M_trans, M_target_true)))
}
}
