% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramTMB.R
\name{tramME_model}
\alias{tramME_model}
\title{Create an object that defines a tramME_model}
\usage{
tramME_model(
  formula = NULL,
  data = NULL,
  tram = NULL,
  ctm = NULL,
  negative = NULL,
  ...
)
}
\arguments{
\item{formula}{formula that either describes the whole model or
the random effects specification. If the model contains random effects,
\code{formula} has to contain their definition in \code{lme4}-style notation.}

\item{data}{an optional data frame, list or environment (or object
          coercible by \code{as.data.frame} to a data frame) containing the
          variables in the model.  If not found in \code{data}, the
          variables are taken from \code{environment(formula)}.
  }

\item{tram}{tram model name: Lm, BoxCox, Colr, Polr, Coxph, Survreg, Lehmann,
Aareg, or the suffixed versions of these (e.g. ColrME). Ignored when a \code{ctm} model
is also supplied.}

\item{ctm}{A \code{ctm} model}

\item{negative}{an optional parameter that defines whether the random effects have
a positive or a negative sign in the model when the fixed effecst part is defined
through a ctm}

\item{...}{optional arguments passed to \pkg{tram} when the model is defined by the formula}
}
\value{
A tramME_model object that defines the mixed effects transfromation model.
}
\description{
There are two ways of defining tramME models:
\enumerate{
  \item A ctm model and a formula defining the random effects.
  \item A formula combining the notation of \pkg{tram} and \pkg{lme4},
    a tram function name, and a dataset to set up the bases.
}
}
\note{
Similarly to \pkg{mlt}, the offsets and the weights are not part of the model,
  but they are data and they are not saved in the returned object.
}
