% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Step3Clusters.R
\name{Step3Clusters}
\alias{Step3Clusters}
\alias{print.trajClusters}
\alias{summary.trajClusters}
\title{Classify the Longitudinal Data Based on the Selected Measures.}
\usage{
Step3Clusters(
  trajSelection,
  algorithm = "k-medoids",
  metric = "euclidean",
  nstart = 200,
  iter.max = 100,
  nclusters = NULL,
  criterion = "Calinski-Harabasz",
  K.max = min(15, nrow(trajSelection$selection) - 1),
  boot = FALSE,
  R = 100,
  B = 500
)

\method{print}{trajClusters}(x, ...)

\method{summary}{trajClusters}(object, ...)
}
\arguments{
\item{trajSelection}{object of class \code{trajSelection} as returned by
\code{Step2Selection}.}

\item{algorithm}{either \code{"k-medoids"} or \code{"k-means"}. Determines the clustering algorithm to use. Defaults to \code{"k-medoids"}.}

\item{metric}{to be passed to the \code{metric} argument of
\code{\link[cluster]{pam}} if \code{"k-medoids"} is the chosen \code{algorithm}. Defaults to \code{"euclidean"}.}

\item{nstart}{to be passed to the \code{nstart} argument of
\code{\link[stats]{kmeans}} if \code{"k-means"} is the chosen \code{algorithm}. Defaults to \code{200}.}

\item{iter.max}{to be passed to the \code{iter.max} argument of
\code{\link[stats]{kmeans}} if \code{"k-means"} is the chosen \code{algorithm}. Defaults to \code{100}.}

\item{nclusters}{either \code{NULL} or the desired number of clusters. If \code{NULL}, the
number of clusters is determined using the criterion chosen in \code{criterion}. Defaults to \code{NULL}.}

\item{criterion}{criterion to determine the optimal number of clusters if \code{nclusters} is \code{NULL}. Either \code{"GAP"} or \code{"Calinski-Harabasz"}. Defaults to \code{"Calinski-Harabasz"}.}

\item{K.max}{maximum number of clusters to be considered if \code{nclusters} is set to \code{NULL}. Defaults to \code{15}.}

\item{boot}{logical. If \code{TRUE}, and if \code{"Calinski-Harabasz"} is the chosen \code{criterion}, the optimal number of clusters will be the first mode of sampling distribution of the optimal number of clusters obtained by bootstrap. Defaults to \code{FALSE}.}

\item{R}{the number of bootstrap replicate if \code{boot} is set to \code{TRUE}. Defaults to \code{100}.}

\item{B}{to be passed to the \code{B} argument of
\code{\link[cluster]{clusGap}} if \code{"GAP"} is the chosen \code{criterion}.}

\item{x}{object of class \code{trajClusters}.}

\item{...}{further arguments passed to or from other methods.}

\item{object}{object of class \code{trajClusters}.}
}
\value{
An object of class \code{trajClusters}; a list containing the result
of the clustering, as well as a curated form of the arguments.
}
\description{
Classifies the trajectories by applying the k-means clustering
algorithm to the measures selected by \code{Step2Selection}.
}
\details{
If \code{"GAP"} is the chosen \code{criterion} for determining the optimal number of clusters, the method described by Tibshirani et al. is implemented by the \code{\link[cluster]{clusGap}} function.

Instead, if \code{"Calinski-Harabasz"} is the chosen \code{criterion}, the Calinski-Harabasz index is computed for each possible number of clusters between 2 and \code{K.max} and the optimal number of clusters is the maximizer of the Calinski-Harabasz index. Moreover, if \code{boot} is set to \code{TRUE}, then, following the guidelines suggested by Mesidor et al., a sampling distribution of the optimal number of clusters is obtained by bootstrap and the optimal number of clusters is chosen to be the (first) mode of this sampling distribution.
}
\examples{
\dontrun{
data("trajdata")
trajdata.noGrp <- trajdata[, -which(colnames(trajdata) == "Group")] #remove the Group column

m = Step1Measures(trajdata.noGrp, ID = TRUE, measures = 1:18)
s = Step2Selection(m)

s$RC$loadings

s2 = Step2Selection(m, select = c(10, 12, 8, 4))

c3.part <- Step3Clusters(s2, nclusters = 3)$partition
c4.part <- Step3Clusters(s2, nclusters = 4)$partition
c5.part <- Step3Clusters(s2, nclusters = 5)$partition

}

}
\references{
Miceline Mésidor, Caroline Sirois, Marc Simard, Denis Talbot, A Bootstrap Approach for Evaluating Uncertainty in the Number of Groups Identified by Latent Class Growth Models, American Journal of Epidemiology, Volume 192, Issue 11, November 2023, Pages 1896–1903, https://doi.org/10.1093/aje/kwad148

Tibshirani, R., Walther, G. and Hastie, T. (2001). Estimating the number of data clusters via the Gap statistic. Journal of the Royal Statistical Society B, 63, 411–423.

Tibshirani, R., Walther, G. and Hastie, T. (2000). Estimating the number of clusters in a dataset via the Gap statistic. Technical Report. Stanford.
}
\seealso{
\code{\link[traj]{Step2Selection}}
}
