% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{equivalent}
\alias{equivalent}
\title{Test two numeric vectors for equivalence}
\usage{
equivalent(x, y, signMatters = TRUE, ...)
}
\arguments{
\item{x}{The first numeric vector.}

\item{y}{The second numeric vector.}

\item{signMatters}{Logical value: if FALSE then equivalence in absolute
value is sufficient.}

\item{\dots}{Additional arguments to \code{\link{all.equal}}, notably
\code{tolerance}.}
}
\value{
\code{TRUE} if all elements of \code{x} match all elements of
  \code{y} to within tolerance, ignoring signs if required. \code{FALSE}
  otherwise.
}
\description{
This function is a wrapper for \code{isTRUE(all.equal(x,y,\dots{}))}, but
with the additional capability of doing sign-insensitive comparison.
}
\examples{

equivalent(c(-1,1), c(1,1))  # FALSE
equivalent(c(-1,1), c(1,1), signMatters=FALSE)  # TRUE
equivalent(1:2, 2:3, tolerance=2)  # TRUE

}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18.
\url{https://www.jstatsoft.org/v44/i08/}.
}
\seealso{
\code{\link{all.equal}}
}
\author{
Jon Clayden
}
