% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz.R
\name{createSliceGraphic}
\alias{createSliceGraphic}
\alias{visualisation}
\alias{createProjectionGraphic}
\alias{createContactSheetGraphic}
\title{Visualise MriImage objects}
\usage{
createSliceGraphic(image, x = NA, y = NA, z = NA,
  device = c("internal", "png"), colourScale = 1, add = FALSE,
  file = NULL, zoomFactor = 1, windowLimits = NULL)

createProjectionGraphic(image, axis, device = c("internal", "png"),
  colourScale = 1, add = FALSE, file = NULL, zoomFactor = 1,
  windowLimits = NULL)

createContactSheetGraphic(image, axis, device = c("internal", "png"),
  colourScale = 1, add = FALSE, file = NULL, zoomFactor = 1,
  windowLimits = NULL, clearance = NULL, nColumns = NULL)
}
\arguments{
\item{image}{An \code{\link{MriImage}} object.}

\item{x, y, z}{Integer vectors, each of length 1. Exactly one of these must be
specified to indicate the plane of interest.}

\item{device}{Either \code{"internal"} for display on the default graphics
device, or \code{"png"} for creating PNG format image file(s).
Abbreviations are fine.}

\item{colourScale}{A colour scale definition, of the sort generated by
\code{\link{getColourScale}}.}

\item{add}{Overlay the graphic on a previous one. Used only when
\code{device} is \code{"internal"}.}

\item{file}{A file name, to be used when \code{device} is \code{"png"}.}

\item{zoomFactor}{Factor by which to enlarge the image. Applies only when
\code{device} is \code{"png"}.}

\item{windowLimits}{Numeric vector of length 2 giving the limits of the
colour scale, or \code{NULL} for limits matching the range of the image
data. Passed as the \code{zlim} argument to \code{\link{image}}.}

\item{axis}{A vector of axes along which slice/projection images should
be created. 1 is left-right, 2 is anterior-posterior, 3 is
superior-inferior.}

\item{clearance}{Number of voxels' clearance to leave around each slice
image in the contact sheet. Passed to \code{\link{trimMriImage}}.}

\item{nColumns}{Number of slices per row in the contact sheet grid. If
\code{NULL}, the function will aim for a square grid.}
}
\value{
These functions are called for their side effects.
}
\description{
Visualise \code{MriImage} objects noninteractively using an R graphics
device. See \code{\link{viewImages}} for an interactive alternative. These
functions create 2D visualisations of 3D images by slicing or maximum
intensity projection.
}
\note{
When the \code{device} option is set to \code{"png"}, the \code{"png"}
and \code{"mmand"} packages are required by these functions.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18.
\url{http://www.jstatsoft.org/v44/i08/}.
}
\seealso{
See \code{\link{viewImages}} for an interactive alternative, and
\code{\link{getColourScale}} for details of how colour scales are specified.
Also \code{\link{image}}, which is used as the underlying plot function.
}
\author{
Jon Clayden
}
