% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_create_fb_matrix}
\alias{functional_create_fb_matrix}
\title{Frequency Bin Conversion Matrix (functional)}
\usage{
functional_create_fb_matrix(
  n_freqs,
  f_min,
  f_max,
  n_mels,
  sample_rate,
  norm = NULL
)
}
\arguments{
\item{n_freqs}{(int): Number of frequencies to highlight/apply}

\item{f_min}{(float): Minimum frequency (Hz)}

\item{f_max}{(float or NULL): Maximum frequency (Hz). If NULL defaults to sample_rate \%/\% 2}

\item{n_mels}{(int): Number of mel filterbanks}

\item{sample_rate}{(int): Sample rate of the audio waveform}

\item{norm}{(chr) (Optional): If 'slaney', divide the triangular
mel weights by the width of the mel band (area normalization). (Default: \code{NULL})}
}
\value{
\code{tensor}: Triangular filter banks (fb matrix) of size (\code{n_freqs}, \code{n_mels})
meaning number of frequencies to highlight/apply to x the number of filterbanks.
Each column is a filterbank so that assuming there is a matrix A of
size (..., \code{n_freqs}), the applied result would be
\code{A * functional_create_fb_matrix(A.size(-1), ...)}.
}
\description{
Create a frequency bin conversion matrix.
}
