% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_poisson}
\alias{torch_poisson}
\title{Poisson}
\usage{
torch_poisson(self, generator = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor containing the rates of the Poisson distribution}

\item{generator}{(\code{torch.Generator}, optional) a pseudorandom number generator for sampling}
}
\description{
Poisson
}
\section{poisson(input *, generator=NULL) -> Tensor }{


Returns a tensor of the same size as \code{input} with each element
sampled from a Poisson distribution with rate parameter given by the corresponding
element in \code{input} i.e.,

\deqn{
    \mbox{out}_i \sim \mbox{Poisson}(\mbox{input}_i)
}
}

\examples{
if (torch_is_installed()) {

rates = torch_rand(c(4, 4)) * 5  # rate parameter between 0 and 5
torch_poisson(rates)
}
}
