% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autograd.R
\name{with_detect_anomaly}
\alias{with_detect_anomaly}
\title{Context-manager that enable anomaly detection for the autograd engine.}
\usage{
with_detect_anomaly(code)
}
\arguments{
\item{code}{Cod that will be execued in the detect anomaly context.}
}
\description{
This does two things:
\itemize{
\item Running the forward pass with detection enabled will allow the backward
pass to print the traceback of the forward operation that created the failing
backward function.
\item Any backward computation that generate "nan" value will raise an error.
}
}
\section{Warning}{

This mode should be enabled only for debugging as the different tests
will slow down your program execution.
}

\examples{
if (torch_is_installed()) {
x <- torch_randn(2, requires_grad = TRUE)
y <- torch_randn(1)
b <- (x^y)$sum()
y$add_(1)

try({

b$backward()

with_detect_anomaly({
  b$backward()
})

})

}
}
