% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions-gamma.R
\name{distr_gamma}
\alias{distr_gamma}
\title{Creates a Gamma distribution parameterized by shape \code{concentration} and \code{rate}.}
\usage{
distr_gamma(concentration, rate, validate_args = NULL)
}
\arguments{
\item{concentration}{(float or Tensor): shape parameter of the distribution
(often referred to as alpha)}

\item{rate}{(float or Tensor): rate = 1 / scale of the distribution
(often referred to as beta)}

\item{validate_args}{whether to validate arguments or not.}
}
\description{
Creates a Gamma distribution parameterized by shape \code{concentration} and \code{rate}.
}
\examples{
if (torch_is_installed()) {
m <- distr_gamma(torch_tensor(1.0), torch_tensor(1.0))
m$sample()  # Gamma distributed with concentration=1 and rate=1
}
}
\seealso{
\link{Distribution} for details on the available methods.

Other distributions: 
\code{\link{distr_bernoulli}()},
\code{\link{distr_chi2}()},
\code{\link{distr_multivariate_normal}()},
\code{\link{distr_normal}()},
\code{\link{distr_poisson}()}
}
\concept{distributions}
