% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions-chi2.R
\name{distr_chi2}
\alias{distr_chi2}
\title{Creates a Chi2 distribution parameterized by shape parameter \code{df}.
This is exactly equivalent to \code{distr_gamma(alpha=0.5*df, beta=0.5)}}
\usage{
distr_chi2(df, validate_args = NULL)
}
\arguments{
\item{df}{(float or torch_tensor): shape parameter of the distribution}

\item{validate_args}{whether to validate arguments or not.}
}
\description{
Creates a Chi2 distribution parameterized by shape parameter \code{df}.
This is exactly equivalent to \code{distr_gamma(alpha=0.5*df, beta=0.5)}
}
\examples{
if (torch_is_installed()) {
m <- distr_chi2(torch_tensor(1.0))
m$sample()  # Chi2 distributed with shape df=1
torch_tensor(0.1046)

}
}
\seealso{
\link{Distribution} for details on the available methods.

Other distributions: 
\code{\link{distr_bernoulli}()},
\code{\link{distr_gamma}()},
\code{\link{distr_normal}()},
\code{\link{distr_poisson}()}
}
\concept{distributions}
