% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-loss.R
\name{nnf_ctc_loss}
\alias{nnf_ctc_loss}
\title{Ctc_loss}
\usage{
nnf_ctc_loss(
  log_probs,
  targets,
  input_lengths,
  target_lengths,
  blank = 0,
  reduction = c("mean", "sum", "none"),
  zero_infinity = FALSE
)
}
\arguments{
\item{log_probs}{\eqn{(T, N, C)} where C = number of characters in alphabet including blank,
T = input length, and N = batch size. The logarithmized probabilities of
the outputs (e.g. obtained with \link{nnf_log_softmax}).}

\item{targets}{\eqn{(N, S)} or \code{(sum(target_lengths))}. Targets cannot be blank.
In the second form, the targets are assumed to be concatenated.}

\item{input_lengths}{\eqn{(N)}. Lengths of the inputs (must each be \eqn{\leq T})}

\item{target_lengths}{\eqn{(N)}. Lengths of the targets}

\item{blank}{(int, optional) Blank label. Default \eqn{0}.}

\item{reduction}{(string, optional) – Specifies the reduction to apply to the
output: 'none' | 'mean' | 'sum'. 'none': no reduction will be applied, 'mean':
the sum of the output will be divided by the number of elements in the output,
'sum': the output will be summed. Default: 'mean'}

\item{zero_infinity}{(bool, optional) Whether to zero infinite losses and the
associated gradients. Default: \code{FALSE} Infinite losses mainly occur when the
inputs are too short to be aligned to the targets.}
}
\description{
The Connectionist Temporal Classification loss.
}
