% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_matrix_power}
\alias{linalg_matrix_power}
\title{Computes the \code{n}-th power of a square matrix for an integer \code{n}.}
\usage{
linalg_matrix_power(A, n)
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, m, m)} where \code{*} is zero or more batch dimensions.}

\item{n}{(int): the exponent.}
}
\description{
Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices then
the output has the same batch dimensions.
}
\details{
If \code{n=0}, it returns the identity matrix (or batch) of the same shape
as \code{A}. If \code{n} is negative, it returns the inverse of each matrix
(if invertible) raised to the power of \code{abs(n)}.
}
\examples{
if (torch_is_installed()) {
A <- torch_randn(3, 3)
linalg_matrix_power(A, 0)
}
}
\seealso{
\code{\link[=linalg_solve]{linalg_solve()}} computes \code{A$inverse() \%*\% B} with a
numerically stable algorithm.

Other linalg: 
\code{\link{linalg_cholesky_ex}()},
\code{\link{linalg_cholesky}()},
\code{\link{linalg_det}()},
\code{\link{linalg_eigh}()},
\code{\link{linalg_eigvalsh}()},
\code{\link{linalg_eigvals}()},
\code{\link{linalg_eig}()},
\code{\link{linalg_householder_product}()},
\code{\link{linalg_inv_ex}()},
\code{\link{linalg_inv}()},
\code{\link{linalg_lstsq}()},
\code{\link{linalg_matrix_norm}()},
\code{\link{linalg_matrix_rank}()},
\code{\link{linalg_multi_dot}()},
\code{\link{linalg_norm}()},
\code{\link{linalg_pinv}()},
\code{\link{linalg_qr}()},
\code{\link{linalg_slogdet}()},
\code{\link{linalg_solve}()},
\code{\link{linalg_svdvals}()},
\code{\link{linalg_svd}()},
\code{\link{linalg_tensorinv}()},
\code{\link{linalg_tensorsolve}()},
\code{\link{linalg_vector_norm}()}
}
\concept{linalg}
