% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-normalization.R
\name{nnf_normalize}
\alias{nnf_normalize}
\title{Normalize}
\usage{
nnf_normalize(input, p = 2, dim = 1, eps = 1e-12, out = NULL)
}
\arguments{
\item{input}{input tensor of any shape}

\item{p}{(float) the exponent value in the norm formulation. Default: 2}

\item{dim}{(int) the dimension to reduce. Default: 1}

\item{eps}{(float) small value to avoid division by zero. Default: 1e-12}

\item{out}{(Tensor, optional) the output tensor. If \code{out} is used, this                            operation won't be differentiable.}
}
\description{
Performs \eqn{L_p} normalization of inputs over specified dimension.
}
\details{
For a tensor \code{input} of sizes \eqn{(n_0, ..., n_{dim}, ..., n_k)}, each
\eqn{n_{dim}} -element vector \eqn{v} along dimension \code{dim} is transformed as

\deqn{
        v = \frac{v}{\max(\Vert v \Vert_p, \epsilon)}.
}

With the default arguments it uses the Euclidean norm over vectors along
dimension \eqn{1} for normalization.
}
