% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R
\name{torch_unsqueeze}
\alias{torch_unsqueeze}
\title{Unsqueeze}
\arguments{
\item{input}{(Tensor) the input tensor.}

\item{dim}{(int) the index at which to insert the singleton dimension}
}
\description{
Unsqueeze
}
\section{unsqueeze(input, dim) -> Tensor }{


Returns a new tensor with a dimension of size one inserted at the
specified position.

The returned tensor shares the same underlying data with this tensor.

A \code{dim} value within the range \verb{[-input.dim() - 1, input.dim() + 1)}
can be used. Negative \code{dim} will correspond to \code{unsqueeze}
applied at \code{dim} = \code{dim + input.dim() + 1}.
}

\examples{
if (torch_is_installed()) {

x = torch_tensor(c(1, 2, 3, 4))
torch_unsqueeze(x, 1)
torch_unsqueeze(x, 2)
}
}
